---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：11-Restart Unit Test.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **C-21**: Dashboard画面からの遷移トリガー名称 - 画面遷移図から推測
  2. **C-28**: 権限による表示制御詳細 - 追加権限設定の有無確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00011.sql` (行1-382)
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql` (行1-1555)
- E-03: `src/plsql/vw/qa_job_run_details_p0011_v.sql` (行1-17)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行12)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (行24, 46, 59, 89)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行27-28)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは11である | E-01 (行15) | ○ |
| C-02 | Page Aliasは'RESTART-UNIT-TEST'である | E-01 (行17) | ○ |
| C-03 | Page Modeは'MODAL'である | E-01 (行18) | ○ |
| C-04 | Dialog Widthは'1000px'である | E-01 (行22) | ○ |
| C-05 | Protection Levelは'C'である | E-01 (行23) | ○ |
| C-06 | P11_RULE_NUMBERはDisplay Onlyである | E-01 (行287) | ○ |
| C-07 | P11_CLIENT_NAMEはDisplay Onlyである | E-01 (行300) | ○ |
| C-08 | P11_SCHEME_NAMEはDisplay Onlyである | E-01 (行318) | ○ |
| C-09 | P11_CUSTOM_JOB_NAMEはHIDDENで自動計算される | E-01 (行271-279) | ○ |
| C-10 | Restart Unit Testボタンはf_exists_custom_job='N'時に表示 | E-01 (行200-205) | ○ |
| C-11 | Unit Test in progressボタンはf_exists_custom_job='Y'時に表示 | E-01 (行220-225) | ○ |
| C-12 | Unit Test in progressボタンはdisabledで表示 | E-01 (行227) | ○ |
| C-13 | RefreshボタンはDynamic Actionでlocation.reload()を実行 | E-01 (行341-342) | ○ |
| C-14 | CloseボタンはDynamic ActionでNATIVE_DIALOG_CLOSEを実行 | E-01 (行360-361) | ○ |
| C-15 | Create Jobプロセスはp_create_custom_unit_test_jobを呼び出す | E-01 (行369-372) | ○ |
| C-16 | ジョブ成功メッセージは'Job started.'である | E-01 (行376) | ○ |
| C-17 | Job HistoryはQA_JOB_RUN_DETAILS_P0011_Vビューを使用 | E-01 (行75) | ○ |
| C-18 | Job Historyは5件ずつ表示（query_num_rows=5） | E-01 (行82) | ○ |
| C-19 | Job HistoryはLazy Loadingが有効 | E-01 (行80) | ○ |
| C-20 | Job History No Dataメッセージの内容 | E-01 (行84) | ○ |
| C-21 | Dashboard画面からRestartリンクで遷移する | E-05 (行46, 89) | △ |
| C-22 | p_create_custom_unit_test_jobは5秒後にジョブを開始する | E-02 (行892) | ○ |
| C-23 | ジョブはauto_drop=trueで作成される | E-02 (行905) | ○ |
| C-24 | f_get_job_nameでジョブ名が生成される | E-02 (行893-897, 1170-1220) | ○ |
| C-25 | f_exists_custom_jobはUSER_SCHEDULER_JOBSを確認する | E-02 (行1247-1252) | ○ |
| C-26 | qa_job_run_details_p0011_vはUSER_SCHEDULER_JOB_RUN_DETAILSから取得 | E-03 (行14) | ○ |
| C-27 | 関連機能No.17, 18が紐づく | E-06 (行27-28) | ○ |
| C-28 | 権限による表示制御は特定ロール制御なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-21**: Dashboard画面のRestartリンクの実装詳細
  - 画面遷移図には記載があるが、page_00001.sqlの詳細を確認していないため、リンクの実装方法は推測
  - 候補：page_00001.sql内のInteractive Report列定義 / JavaScript呼び出し / URL Link

- **C-28**: 追加のロールベース権限制御の有無
  - p_protection_level=>'C'は認証済みユーザーのみアクセス可能を意味するが、追加のロールチェックの有無は未確認
  - 候補：Application-level Authorization Schemes / Page-level Authorization

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全体的に高い信頼度。ソースコードから直接確認できる項目が多い。
- **1（中リスク）**: Dashboard画面との連携部分（遷移元）は推測を含む。必要に応じてpage_00001.sqlを確認。

## 6) レビュアーチェックリスト（最小）
- [ ] Dashboard画面（Page 1）のRestartリンク実装を確認し、パラメータの渡し方が設計書と一致しているか
- [ ] f_exists_custom_jobの戻り値がUI表示条件と整合しているか
- [ ] Job Historyビューのジョブ名絞り込み条件（P11_CUSTOM_JOB_NAME）が正しく機能するか
- [ ] DBMS_SCHEDULER権限がQUASTOスキーマに付与されているか確認
